<?php

/*--------------------------------------------------------------*/
/*                          INCLUDES                            */
/*--------------------------------------------------------------*/

include "inc/core/meta-fields.php";
include "inc/core/post-type.php";
include "inc/core/taxonomy.php";
include "inc/libs/aqua-resize/aqua_resize.php";
include get_template_directory() . "/inc/core/slots-import.php";

register_nav_menus(array(
    'top' => 'Меню в шапке',
    'footer' => 'Меню в футере',
));


add_action('wp_enqueue_scripts', 'theme_src');
function theme_src()
{
    wp_enqueue_style('main-css', get_stylesheet_uri(), array(), null);
    wp_enqueue_script('jquery1', get_template_directory_uri() . '/assets/js/jquery-3.6.4.js', array(), null, true);
    wp_enqueue_script('formstyler', get_template_directory_uri() . '/assets/js/jquery.formstyler.min.js', array(), null, true);
    wp_enqueue_script('swiper-js', get_template_directory_uri() . '/assets/js/swiper-bundle.min.js', array(), '1.0.0', true);
    wp_enqueue_script('main-js', get_template_directory_uri() . '/assets/js/script.js', array(), '1.0.0', true);
}

add_theme_support('title-tag');
add_theme_support('post-thumbnails');


add_action('after_setup_theme', 'my_theme_setup');

function my_theme_setup()
{
    load_theme_textdomain('mostbet', get_template_directory() . '/lang');
}


function load_template_part($template_name, $part_name = null)
{
    ob_start();
    get_template_part($template_name, $part_name);
    $var = ob_get_contents();
    ob_end_clean();

    return $var;
}

function load_posts()
{
    $result = '';
    $args = unserialize(stripslashes($_POST['query']));
    $args['paged'] = $_POST['page'] + 1; // следующая страница
    $args['post_status'] = 'publish';
    $args['post_type'] = 'slots';
    query_posts($args);
    if (have_posts()) :
        while (have_posts()): the_post();
            $result .= load_template_part('loop/slot_item');
        endwhile;
    endif;
    die($result);
}


add_action('wp_ajax_loadmore', 'load_posts');
add_action('wp_ajax_nopriv_loadmore', 'load_posts');


function filter_slots()
{
    $result = '';
    $arr_soft = $_POST['arr_soft'];
    $args = [];
    if ($arr_soft) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'soft',
                'field' => 'id',
                'terms' => $arr_soft
            )
        );
    }

    $args['post_type'] = 'slots';
    $args['posts_per_page'] = -1;
    query_posts($args);
    if (have_posts()) :
        while (have_posts()): the_post();
            $result .= load_template_part('loop/slot_item');
        endwhile;
    endif;
    die($result);
}


add_action('wp_ajax_sort', 'filter_slots');
add_action('wp_ajax_nopriv_sort', 'filter_slots');


function pagination($prev = '«', $next = '»')
{
    global $wp_query, $wp_rewrite;
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    $pagination = array(
        'base' => @add_query_arg('paged', '%#%'),
        'format' => '',
        'total' => $wp_query->max_num_pages,
        'current' => $current,
        'prev_text' => __($prev),
        'next_text' => __($next),
        'type' => 'plain'
    );
    if ($wp_rewrite->using_permalinks())
        $pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');

    if (!empty($wp_query->query_vars['s']))
        $pagination['add_args'] = array('s' => get_query_var('s'));

    echo paginate_links($pagination);
}

function load_att($image)
{
    $image_url = $image;

    $upload_dir = wp_upload_dir();

    $image_data = file_get_contents($image_url);

    $filename = basename($image_url);

    if (wp_mkdir_p($upload_dir['path'])) {
        $file = $upload_dir['path'] . '/' . $filename;
    } else {
        $file = $upload_dir['basedir'] . '/' . $filename;
    }

    file_put_contents($file, $image_data);

    $wp_filetype = wp_check_filetype($filename, null);

    $attachment = array(
        'post_mime_type' => $wp_filetype['type'],
        'post_title' => sanitize_file_name($filename),
        'post_content' => '',
        'post_status' => 'inherit'
    );

    $attach_id = wp_insert_attachment($attachment, $file);
    require_once(ABSPATH . 'wp-admin/includes/image.php');
    $attach_data = wp_generate_attachment_metadata($attach_id, $file);
    wp_update_attachment_metadata($attach_id, $attach_data);

    return $attach_id;
}


if (!function_exists('__')) {
    function __($string)
    {
        return __($string, 'mostbet');
    }
}


function add_additional_class_on_a($classes, $item, $args)
{
    if (isset($args->add_a_class)) {
        $classes['class'] = $args->add_a_class;
    }
    return $classes;
}

add_filter('nav_menu_link_attributes', 'add_additional_class_on_a', 1, 3);




