<?php

use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make('FAQ LIST')
    ->add_fields(array(

        Field::make('text', 'heading', __('H2 перед списом вопросов')),
        Field::make('complex', 'faq', __('Вопросы и ответы'))
            ->add_fields(array(
                Field::make('text', 'q', __('Вопрос')),
                Field::make('textarea', 'a', __('Ответ')),
            ))

    ))
    ->set_render_callback(function ($fields, $attributes, $inner_blocks) {
        $heading = $fields['heading'];
        $faq = $fields['faq'];
        if ($heading) echo '<h2>' . $heading . '</h2>';
        if ($faq):
            ?>
            <div class="layout-accordion accordion" id="accordion">
                <?php foreach ($faq as $item) {
                    $q[] = '{
                               "@type": "Question",
                               "name": "' . htmlspecialchars($item['q']) . '",
                               "acceptedAnswer": {
                               "@type": "Answer",
                                   "text": "' . htmlspecialchars($item['a']) . '"
                                      }
                             }';
                    ?>

                    <div class="accordion__block">
                        <div class="accordion__open link">
                            <div class="arrow-circle"></div>
                            <span><?php echo $item['q']; ?></span>
                        </div>
                        <div class="submenu">
                            <div class="accordion__text">
                                <p>
                                    <?php echo $item['a']; ?>
                                </p>
                            </div>
                        </div>
                    </div>

                <?php } ?>

                <script type="application/ld+json">
                    {
                        "@context": "http:\/\/schema.org",
                        "@type": "FAQPage",
                        "mainEntity": [
                    <?php echo implode(',', $q); ?>
                    ]
               }
                </script>


            </div>
        <?php
        endif;

    });