<?php
/*
  *
  * Template name: Главная
  * */
get_header();
?>
    <main class="main-layout">

<?php get_sidebar('left'); ?>
<?php get_sidebar('right'); ?>

<?php if ($slider = carbon_get_theme_option('slider')): ?>
    <div class="main-glob__block">
        <div class="swiper main-glob__slider">
            <div class="swiper-wrapper">

                <?php foreach ($slider as $item) { ?>
                    <div class="swiper-slide">
                        <a href="<?php echo $item['link']; ?>" class="main-glob__picture">
                            <img src="<?php echo wp_get_attachment_image_src($item['img'], 'full')[0]; ?>"
                                 alt="slider image">
                        </a>
                    </div>
                <?php } ?>

            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
<?php endif; ?>


    <div class="layout__style">

<?php while (have_posts()):the_post(); ?>

    <div class="layout__style_cnt">
        <div class="layout__head">
            <h1><?php echo get_the_title(); ?></h1>
            <a href="<?php echo carbon_get_post_meta(get_the_ID(), 'text_download') ?>" class="layout__download"
               target="_blank" rel="nofollow">
                <?php echo __('Download', 'mostbet'); ?>
            </a>
        </div>

        <div class="layout__text">
            <?php the_content(); ?>

            <?php comments_template('') ?>

        </div>
    </div>
<?php endwhile; ?>

<?php get_footer(); ?>